#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//sphere stuffMod01.fsh   by   tly  
//https://www.shadertoy.com/view/MlBXzm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct Ray{
	vec3 p,v;
};
	
struct Sphere{
	vec3 o;
	float r;
};
	
struct Hit{
	vec3 p;
	vec3 n;
	float l;
};

vec3 color(int index){
	if(index == 0) return vec3(0,0,1);
    if(index == 1) return vec3(0,1,1);
    if(index == 2) return vec3(1,0,0);
    if(index == 3) return vec3(1,1,0);
    if(index == 4) return vec3(0,1,0);
    if(index == 5) return vec3(1,0,1);
    else return vec3(0);
}
const float infinity = 100000000000.0;
	
Hit hit(Ray ray,Sphere sphere){
	vec3 o = sphere.o - ray.p;
	
	float p = dot(ray.v,o);
	float q = dot(o,o) - sphere.r * sphere.r;
	
	vec2 d = p + vec2(1,-1) * sqrt(p*p - q);
	vec3 p0 = ray.p + ray.v * min(d.x,d.y);
	return Hit(
        p0, //hitpoint
        (p0 - sphere.o)/sphere.r, //avoiding "normalize"
        (d.x > 0.0 && d.y > 0.0) ? min(d.x,d.y) : infinity //throw away if hitpoints are behind the rayposition
	);	
}

vec3 rotateY(in vec3 v, in float a) {
	return vec3(cos(a)*v.x + sin(a)*v.z, v.y,-sin(a)*v.x + cos(a)*v.z);
}

vec3 rotateX(in vec3 v, in float a) {
	return vec3(v.x,cos(a)*v.y + sin(a)*v.z,-sin(a)*v.y + cos(a)*v.z);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = (fragCoord.xy - iResolution.xy*0.5 )/iResolution.y;
	
	Ray ray = Ray(vec3(0),normalize(vec3(uv.x,uv.y,0.75)));
	ray.v = rotateY(ray.v,-0.1 * iTime);
    ray.v = rotateX(ray.v,-0.13 * iTime);
	
	float r = mix(0.6,sqrt(3.0) * 0.5,min(1.0,1.5 * pow(sin(iTime) * 0.5 + 0.5,0.3)));
	Sphere spheres[6];
    spheres[0] = Sphere(vec3(0,0,+1),r);
	spheres[1] = Sphere(vec3(0,0,-1),r);
	spheres[2] = Sphere(vec3(0,+1,0),r);
	spheres[3] = Sphere(vec3(0,-1,0),r);
	spheres[4] = Sphere(vec3(+1,0,0),r);
	spheres[5] = Sphere(vec3(-1,0,0),r);
	
    float factor = 0.7;
    float lightStrength = 1.0;
    fragColor = vec4(0,0,0,1);
	
	const int REFLECTIONS = 9;
	for(int i = 0; i < REFLECTIONS; i++){
        Hit h = Hit(vec3(0),vec3(0),infinity);
        int found = -1;
		for(int j = 0; j < 6; j++){
			Hit x = hit(ray,spheres[j]);
            if(x.l < h.l){
                h = x;
                found = j;
           	}
		}
		if(found != -1){
			ray.p = h.p;
			ray.v = reflect(ray.v,h.n);
            
            vec3 lightVec = -normalize(h.p);
            float diffuse = dot(h.n,lightVec);
            float specular = pow(abs(dot(reflect(-lightVec,h.n),lightVec)),20.0);
			fragColor.xyz += lightStrength * (diffuse * color(found) + specular);
        }
        lightStrength *= factor;
	}
	fragColor.xyz *= 1.3 * (1.0 - factor);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

